#ifndef RDMPID_H__
#define RDMPID_H__

#include <stdbool.h>
#include <stdint.h>

#define RDMLABELLENGTH 32

typedef enum {
	RDMPID_DISC_UNIQUE_BRANCH               = 0x1,
	RDMPID_DISC_MUTE                        = 0x2,
	RDMPID_DISC_UN_MUTE                     = 0x3,
	RDMPID_PROXIED_DEVICES                  = 0x10,
	RDMPID_PROXIED_DEVICE_COUNT             = 0x11,
	RDMPID_COMMS_STATUS                     = 0x15,
	RDMPID_QUEUED_MESSAGE                   = 0x20,
	RDMPID_STATUS_MESSAGES                  = 0x30,
	RDMPID_STATUS_ID_DESCRIPTION            = 0x31,
	RDMPID_CLEAR_STATUS_ID                  = 0x32,
	RDMPID_SUPPORTED_PARAMETER              = 0x0050,
	RDMPID_PARAMETER_DESCRIPTION            = 0x0051,
	RDMPID_DEVICEINFO                       = 0x0060,
	RDMPID_PRODUCTDETAILIDLIST              = 0x0070,
	RDMPID_DEVICEMODELDESCRIPTION           = 0x0080,
	RDMPID_MANUFACTURER_LABEL               = 0x0081,
	RDMPID_DEVICE_LABEL                     = 0x0082,
	RDMPID_FACTORY_DEFAULTS                 = 0x0090,
	RDMPID_LANGUAGE_CAPABILITIES            = 0x00A0,
	RDMPID_LANGUAGE                         = 0x00B0,
	RDMPID_SOFTWARE_VERSION_LABEL           = 0x00C0,
	RDMPID_BOOT_SOFTWARE_VERSION_ID         = 0x00C1,
	RDMPID_BOOT_SOFTWARE_VERSION_LABEL      = 0x00C2,
	RDMPID_DMX_PERSONALITY                  = 0x00E0,
	RDMPID_DMX_PERSONALITY_DESCRIPTION      = 0x00E1,
	RDMPID_DMXSTARTADDRESS                  = 0x00F0,
	RDMPID_SLOT_INFO                        = 0x0120,
	RDMPID_SLOT_DESCRIPTION                 = 0x0121,
	RDMPID_DEFAULT_SLOT_VALUE               = 0x0122,
	RDMPID_SENSOR_DEFINITION                = 0x0200,
	RDMPID_SENSOR_VALUE                     = 0x0201,
	RDMPID_RECORD_SENSORS                   = 0x0201,
	RDMPID_DEVICE_HOURS                     = 0x0400,
	RDMPID_LAMP_HOURS                       = 0x0401,
	RDMPID_LAMP_STRIKES                     = 0x0402,
	RDMPID_LAMP_STATE                       = 0x0403,
	RDMPID_LAMP_ON_MODE                     = 0x0404,
	RDMPID_DEVICE_POWER_CYCLES              = 0x0405,
	RDMPID_DISPLAY_INVERT                   = 0x0500,
	RDMPID_DISPLAY_LEVEL                    = 0x0501,
	RDMPID_PAN_INVERT                       = 0x0600,
	RDMPID_TILT_INVERT                      = 0x0601,
	RDMPID_PAN_TILT_SWAP                    = 0x0602,
	RDMPID_REAL_TIME_CLOCK                  = 0x0603,
	RDMPID_IDENTIFY_DEVICE                  = 0x1000,
	RDMPID_RESET_DEVICE                     = 0x1001,
	RDMPID_POWER_STATE                      = 0x1010,
	RDMPID_PERFORM_SELFTEST                 = 0x1020,
	RDMPID_SELF_TEST_DESCRIPTION            = 0x1021,
	RDMPID_CAPTURE_PRESET                   = 0x1030,
	RDMPID_PRESET_PLAYBACK                  = 0x1031,
	RDMPID_DIMMER_INFO                      = 0x0340,
	RDMPID_MINIMUM_LEVEL                    = 0x0341,
	RDMPID_MAXIMUM_LEVEL                    = 0x0342,
	RDMPID_CURVE                            = 0x0343,
	RDMPID_CURVE_DESCRIPTION                = 0x0344,
	RDMPID_OUTPUT_RESPONSE_TIME             = 0x0345,
	RDMPID_OUTPUT_RESPONSE_TIME_DESCRIPTION = 0x0346,
	RDMPID_MODULATION_FREQUENCY             = 0x0347,
	RDMPID_MODULATION_FREQUENCY_DESCRIPTION = 0x0348,
	RDMCPID_IQ                              = 0xA000,
	RDMCPID_CUSTOM_ADJUSTLEDCALIBRATIONDATA  = 0x9017,
	RDMCPID_CUSTOM_ERROR                     = 0x8030,
	RDMCPID_CUSTOM_WARNING                   = 0x8031,
	RDMCPID_CUSTOM_ADJUSTLEDCALIBRATIONDEBUG = 0x9019,
	RDMCPID_CUSTOM_ADJUSTLEDCALIBRATIONSEND  = 0x9018,
	RDMCPID_CUSTOM_SERVICEHOURS              = 0x8402,
	RDMCPID_CUSTOM_TOTALDEVICEHOURS          = 0x8403,
	RDMCPID_CUSTOM_TOTALPOWERCYCLES          = 0x8405,
	RDMCPID_CUSTOM_TOTALLAMPHOURS            = 0x8404,
	RDMCPID_COLORCONVERTER_LICENSE          = 0xA002,
	RDMCPID_COLORCONVERTER_CALIBRATION      = 0xA003,
	RDMCPID_COLORCONVERTER_CONTROL          = 0xA004,
	RDMCPID_DFU							    = 0xA005,
} rdm_pid_t;

typedef enum {
	RDMLAMP_STATE_OFF         = 0x00,
	RDMLAMP_STATE_ON          = 0x01,
	RDMLAMP_STATE_STRIKE      = 0x02,
	RDMLAMP_STATE_STANDBY     = 0x03,
	RDMLAMP_STATE_NOT_PRESENT = 0x04,
	RDMLAMP_STATE_ERROR       = 0x7F
} rdm_lampstate_t;

typedef enum {
	RDMPOWER_STATE_FULL_OFF = 0x00,
	RDMPOWER_STATE_SHUTDOWN = 0x01,
	RDMPOWER_STATE_STANDBY  = 0x02,
	RDMPOWER_STATE_NORMAL   = 0xFF
} rdm_powerstate_t;

typedef enum {
	RDMSENS_TEMPERATURE        = 0x00,
	RDMSENS_VOLTAGE            = 0x01,
	RDMSENS_CURRENT            = 0x02,
	RDMSENS_FREQUENCY          = 0x03,
	RDMSENS_RESISTANCE         = 0x04,
	RDMSENS_POWER              = 0x05,
	RDMSENS_MASS               = 0x06,
	RDMSENS_LENGTH             = 0x07,
	RDMSENS_AREA               = 0x08,
	RDMSENS_VOLUME             = 0x09,
	RDMSENS_DENSITY            = 0x0A,
	RDMSENS_VELOCITY           = 0x0B,
	RDMSENS_ACCELERATION       = 0x0C,
	RDMSENS_FORCE              = 0x0D,
	RDMSENS_ENERGY             = 0x0E,
	RDMSENS_PRESSURE           = 0x0F,
	RDMSENS_TIME               = 0x10,
	RDMSENS_ANGLE              = 0x11,
	RDMSENS_POSITIONX          = 0x12,
	RDMSENS_POSITIONY          = 0x13,
	RDMSENS_POSITIONZ          = 0x14,
	RDMSENS_ANGULAR_VELOCITY   = 0x15,
	RDMSENS_LUMINOUS_INTENSITY = 0x16,
	RDMSENS_LUMINOUS_FLUX      = 0x17,
	RDMSENS_ILLUMINANCE        = 0x18,
	RDMSENS_CHROMINANCE_RED    = 0x19,
	RDMSENS_CHROMINANCE_GREEN  = 0x1A,
	RDMSENS_CHROMINANCE_BLUE   = 0x1B,
	RDMSENS_CONTACTS           = 0x1C,
	RDMSENS_MEMORY             = 0x1D,
	RDMSENS_ITEMS              = 0x1E,
	RDMSENS_HUMIDITY           = 0x1F,
	RDMSENS_COUNTER_16BIT      = 0x20,
	RDMSENS_OTHER              = 0x7F
} rdm_sensor_type_t;

typedef enum {
	RDMUNITS_NONE                        = 0x00,
	RDMUNITS_CENTIGRADE                  = 0x01,
	RDMUNITS_VOLTS_DC                    = 0x02,
	RDMUNITS_VOLTS_AC_PEAK               = 0x03,
	RDMUNITS_VOLTS_AC_RMS                = 0x04,
	RDMUNITS_AMPERE_DC                   = 0x05,
	RDMUNITS_AMPERE_AC_PEAK              = 0x06,
	RDMUNITS_AMPERE_AC_RMS               = 0x07,
	RDMUNITS_HERTZ                       = 0x08,
	RDMUNITS_OHM                         = 0x09,
	RDMUNITS_WATT                        = 0x0A,
	RDMUNITS_KILOGRAM                    = 0x0B,
	RDMUNITS_METERS                      = 0x0C,
	RDMUNITS_METERS_SQUARED              = 0x0D,
	RDMUNITS_METERS_CUBED                = 0x0E,
	RDMUNITS_KILOGRAMMES_PER_METER_CUBED = 0x0F,
	RDMUNITS_METERS_PER_SECOND           = 0x10,
	RDMUNITS_METERS_PER_SECOND_SQUARED   = 0x11,
	RDMUNITS_NEWTON                      = 0x12,
	RDMUNITS_JOULE                       = 0x13,
	RDMUNITS_PASCAL                      = 0x14,
	RDMUNITS_SECOND                      = 0x15,
	RDMUNITS_DEGREE                      = 0x16,
	RDMUNITS_STERADIAN                   = 0x17,
	RDMUNITS_CANDELA                     = 0x18,
	RDMUNITS_LUMEN                       = 0x19,
	RDMUNITS_LUX                         = 0x1A,
	RDMUNITS_IRE                         = 0x1B,
	RDMUNITS_BYTE                        = 0x1C
} rdm_units_t;

typedef enum { RDM_RESET_WARM = 0x1, RDM_RESET_COLD = 0xFF } rdm_reset_t;

typedef enum {
	RDM_LAMP_ON_MODE_OFF       = 0x0,
	RDM_LAMP_ON_MODE_DMX       = 0x01,
	RDM_LAMP_ON_MODE_ON        = 0x02,
	RDM_LAMP_ON_MODE_AFTER_CAL = 0x03,
} rdm_lamp_on_mode_t;

typedef enum {
	RDM_DISPLAY_INVERT_OFF  = 0x0,
	RDM_DISPLAY_INVERT_ON   = 0x01,
	RDM_DISPLAY_INVERT_AUTO = 0x02,
} rdm_display_invert_t;

typedef enum {
	RDM_PREFIX_NONE   = 0x00,
	RDM_PREFIX_DECI   = 0x01,
	RDM_PREFIX_CENTI  = 0x02,
	RDM_PREFIX_MILLI  = 0x03,
	RDM_PREFIX_MICRO  = 0x04,
	RDM_PREFIX_NANO   = 0x05,
	RDM_PREFIX_PICO   = 0x06,
	RDM_PREFIX_FEMPTO = 0x07,
	RDM_PREFIX_KILO   = 0x13,
	RDM_PREFIX_MEGA   = 0x14,
} rdm_prefix_t;

typedef enum {
	RDM_PD_CC_GET     = 0x01,
	RDM_PD_CC_SET     = 0x02,
	RDM_PD_CC_GET_SET = 0x03,
} rdm_parameter_description_command_class_t;

typedef enum {
	RDM_DTD_DS_NOT_DEFINED    = 0x00,
	RDM_DTD_DS_BIT_FIELD      = 0x01,
	RDM_DTD_DS_ASCII          = 0x02,
	RDM_DTD_DS_UNSIGNED_BYTE  = 0x03,
	RDM_DTD_DS_SIGNED_BYTE    = 0x04,
	RDM_DTD_DS_UNSIGNED_WORD  = 0x05,
	RDM_DTD_DS_SIGNED_WORD    = 0x06,
	RDM_DTD_DS_UNSIGNED_DWORD = 0x07,
	RDM_DTD_DS_SIGNED_DWORD   = 0x08,
} rdm_data_type_defines_t;

typedef enum {
	RDM_STATUS_NONE             = 0x00,
	RDM_STATUS_GET_LAST_MESSAGE = 0x01,
	RDM_STATUS_ADVISORY         = 0x02,
	RDM_STATUS_WARNING          = 0x03,
	RDM_STATUS_ERROR            = 0x04,
	RDM_STATUS_ADVISORY_CLEARED = 0x12,
	RDM_STATUS_WARNING_CLEARED  = 0x13,
	RDM_STATUS_ERROR_CLEARED    = 0x14,
} rdm_status_type_defines_t;

typedef enum {
	RDMIQSETTINGSCOMMAND_INPUTSOURCE    = 1,
	RDMIQSETTINGSCOMMAND_INPUTSTATE     = 2,
	RDMIQSETTINGSCOMMAND_DISPLAYPOPUP   = 3,
	RDMIQSETTINGSCOMMAND_EMERGENCYMODE  = 4,
	RDMIQSETTINGSCOMMAND_BATTERYRUNTIME = 5,
	RDMIQSETTINGSCOMMAND_ANTITHEFTMODE  = 6,
} rdm_iq_settings_command_t;

#define RDMIQANTITHEFT_KEY_OFF   583619
#define RDMIQANTITHEFT_KEY_ON    204688
#define RDMIQANTITHEFT_KEY_ALARM 388165

typedef enum {
	RDMIQINPUTSOURCE_IQMESH          = 0,
	RDMIQINPUTSOURCE_DMX             = 1,
	RDMIQINPUTSOURCE_CRMXWDMX        = 2,
	RDMIQINPUTSOURCE_ARTNET          = 3,
	RDMIQINPUTSOURCE_SACN            = 4,
	RDMIQINPUTSOURCE_GLPDOP          = 5,
	RDMIQINPUTSOURCE_IRREMOTE        = 6,
	RDMIQINPUTSOURCE_MANUAL          = 7,
	RDMIQINPUTSOURCE_AUTO            = 8,
	RDMIQINPUTSOURCE_WIRELESS2_4GHZ  = 253,
	RDMIQINPUTSOURCE_WIRELESS2_OTHER = 254,
	RDMIQINPUTSOURCE_ETHERNET        = 255,
} rdm_iq_inputsource_t;

typedef enum {
	IQ_POWERSUPPLY_STATE_NOPOWER         = 0,  // No Power (Battery wakeup)
	IQ_POWERSUPPLY_STATE_BATTERY_POWERED = 1,
	IQ_POWERSUPPLY_STATE_GRID_POWERED    = 2,
	IQ_POWERSUPPLY_STATE_CHARGING        = 3,
} rdm_iq_power_supply_state_t;

typedef enum {
	IQ_INPUTSTATE_IDLE     			= 0,
	IQ_INPUTSTATE_UNLINKED 			= 1,
	IQ_INPUTSTATE_LINKED   			= 2,
	IQ_INPUTSTATE_ACTIVE   			= 3,
	IQ_INPUTSTATE_ACTIVE_IQMESH   	= 4,
} rdm_iq_input_state_t;

typedef enum {
	IQ_INPUTSTATE_UNLINK = 0,
	IQ_INPUTSTATE_LINK   = 1,
} rdm_iq_set_input_state_t;

typedef enum {
	RDMIQBATTERYRUNTIME_FULLOUTPUT = 0,
	RDMIQBATTERYRUNTIME_1HOURS     = 1,
	RDMIQBATTERYRUNTIME_2HOURS     = 2,
	RDMIQBATTERYRUNTIME_3HOURS     = 3,
	RDMIQBATTERYRUNTIME_4HOURS     = 4,
	RDMIQBATTERYRUNTIME_5HOURS     = 5,
	RDMIQBATTERYRUNTIME_6HOURS     = 6,
	RDMIQBATTERYRUNTIME_7HOURS     = 7,
	RDMIQBATTERYRUNTIME_8HOURS     = 8,
	RDMIQBATTERYRUNTIME_9HOURS     = 9,
	RDMIQBATTERYRUNTIME_10HOURS    = 10,
	RDMIQBATTERYRUNTIME_11HOURS    = 11,
	RDMIQBATTERYRUNTIME_12HOURS    = 12,
	RDMIQBATTERYRUNTIME_13HOURS    = 13,
	RDMIQBATTERYRUNTIME_14HOURS    = 14,
	RDMIQBATTERYRUNTIME_15HOURS    = 15,
	RDMIQBATTERYRUNTIME_16HOURS    = 16,
	RDMIQBATTERYRUNTIME_17HOURS    = 17,
	RDMIQBATTERYRUNTIME_18HOURS    = 18,
	RDMIQBATTERYRUNTIME_19HOURS    = 19,
	RDMIQBATTERYRUNTIME_20HOURS    = 20,
	RDMIQBATTERYRUNTIME_21HOURS    = 21,
	RDMIQBATTERYRUNTIME_22HOURS    = 22,
	RDMIQBATTERYRUNTIME_23HOURS    = 23,
	RDMIQBATTERYRUNTIME_24HOURS    = 24,
} rdm_iq_battery_runtime_t;

typedef enum { RDMIQANTITHEFT_OFF, RDMIQANTITHEFT_ON, RDMIQANTITHEFT_ALARM } rdm_iq_antitheft_t;

typedef enum {
	RDMIQPOPUPPROGRESS_0   = 0,
	RDMIQPOPUPPROGRESS_100 = 100,
	RDMIQPOPUPPROGRESS_OFF = 255
} rdm_iq_popup_progress_t;

typedef enum {
	RDM_ST_PRIMARY,
	RDM_ST_SEC_FINE,
	RDM_ST_SEC_TIMING,
	RDM_ST_SEC_SPEED,
	RDM_ST_SEC_CONTROL,
	RDM_ST_SEC_INDEX,
	RDM_ST_SEC_ROTATION,
	RDM_ST_SEC_INDEX_ROTATE,
	ST_SEC_UNDEFINED = 0xFF
} rdm_slot_type_t;

typedef enum {
	RDM_SD_INTENSITY         = 0x0001,
	RDM_SD_INTENSITY_MASTER  = 0x002,
	RDM_SD_PAN               = 0x0101,
	RDM_SD_TILT              = 0x0102,
	RDM_SD_COLOR_WHEEL       = 0x0201,
	RDM_SD_COLOR_SUB_CYAN    = 0x0202,
	RDM_SD_COLOR_SUB_YELLOW  = 0x0203,
	RDM_SD_COLOR_SUB_MAGENTA = 0x0204,
	RDM_SD_COLOR_ADD_RED     = 0x0205,
	RDM_SD_COLOR_ADD_GREEN   = 0x0206,
	RDM_SD_COLOR_ADD_BLUE    = 0x0207,
	RDM_SD_COLOR_CORRECTION  = 0x0208,
	RDM_SD_COLOR_SCROLL      = 0x0209,
	RDM_SD_COLOR_SEMAPHORE   = 0x0210,
	RDM_SD_STATIC_GOBO_WHEEL = 0x0301,
	RDM_SD_ROTO_GOBO_WHEEL   = 0x0302,
	RDM_SD_PRISM_WHEEL       = 0x0303,
	RDM_SD_EFFECTS_WHEEL     = 0x0304,
	RDM_SD_BEAM_SIZE_IRIS    = 0x0401,
	RDM_SD_EDGE              = 0x0402,
	RDM_SD_FROST             = 0x0403,
	RDM_SD_STROBE            = 0x0404,
	RDM_SD_ZOOM              = 0x0405,
	RDM_SD_FRAMING_SHUTTER   = 0x0406,
	RDM_SD_SHUTTER_ROTATE    = 0x0407,
	RDM_SD_DOUSER            = 0x0408,
	RDM_SD_BARN_DOOR         = 0x0409,
	RDM_SD_LAMP_CONTROL      = 0x0501,
	RDM_SD_FIXTURE_CONTROL   = 0x0502,
	RDM_SD_FIXTURE_SPEED     = 0x0503,
	RDM_SD_MACRO             = 0x0504,
	RDM_SD_UNDEFINED         = 0xFFFF,
} rdm_slot_id_t;

typedef struct
{
	uint8_t showTimeSec;
	rdm_iq_popup_progress_t progress;
	uint8_t titleLength;
	uint8_t textLength;
	uint8_t title[20];
	uint8_t text[40];

} rdm_iq_popup_t;

typedef struct
{
	uint8_t protocollVersion;
	rdm_iq_settings_command_t command;
} rdm_iq_settings_stream_t;

typedef struct __attribute__((__packed__))
{
	uint8_t lowerBoundUid[6];
	uint8_t upperBoundUid[6];
} rdm_disc_unique_branch_receive_t;

typedef struct __attribute__((__packed__))
{
	uint8_t responsePreamble[7];
	uint8_t preambleSepearator;
	uint8_t eUid[12];
	uint8_t eChecksum[4];
} rdm_disc_unique_branch_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t controlField_res : 8;
	uint16_t controlField_managedProxyFlag : 1;
	uint16_t controlField_subDeviceFlag : 1;
	uint16_t controlField_bootloaderFlag : 1;
	uint16_t controlField_proxiedDeviceFlag : 1;

} rdm_disc_unmute_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t protocollVersion;
	uint16_t deviceModelId;
	uint16_t productCategory;
	uint32_t softwareVersionId;
	uint16_t dmxFootprint;
	uint8_t dmxPersonality;
	uint8_t dmxPersonalityCount;
	uint16_t dmxStartaddress;
	uint16_t SubDeviceCount;
	uint8_t sensorCount;
} rdm_device_info_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t productDetails[6];
	uint8_t productDetailsCount;
} rdm_product_detail_id_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_device_model_description_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_manufacturer_label_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_device_label_get_response_t;

typedef struct __attribute__((__packed__))
{
	bool isDefault;
} rdm_factory_default_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_softwareversion_label_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_boot_softwareversion_label_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t currentPersonality;
	uint8_t numPersonalities;
} rdm_dmx_personality_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedPersonality;
	uint16_t footprint;
	char label[RDMLABELLENGTH];
	uint8_t labelSize;

} rdm_dmx_personality_description_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t address;
} rdm_dmx_startaddress_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedSensor;
	rdm_sensor_type_t type;
	rdm_units_t unit;
	uint8_t prefix;
	int16_t rangeMinimumValue;
	int16_t rangeMaximumValue;
	int16_t normalMinimumValue;
	int16_t normalMaximumValue;
	uint8_t recordedValueSupport;
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_sensor_defintion_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedSensor;
	uint16_t presentValue;
	uint16_t lowestDetectedValue;
	uint16_t highestDetectedValue;
	uint16_t recordedValue;
} rdm_sensor_value_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint32_t deviceHours;
} rdm_device_hours_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint32_t lampHours;
} rdm_lamphours_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint32_t lampStrikes;
} rdm_lampstrike_get_response_t;

typedef struct __attribute__((__packed__))
{
	rdm_lampstate_t lampState;
} rdm_lampstate_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint32_t powerCycleCount;
} rdm_device_power_cycle_get_response_t;

typedef struct __attribute__((__packed__))
{
	bool identifyState;
} rdm_identify_device_get_response_t;

typedef struct __attribute__((__packed__))
{
	rdm_powerstate_t powerState;
} rdm_power_state_get_response_t;

typedef struct __attribute__((__packed__))
{
	bool selfTestsActive;
} rdm_perform_selftest_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedSelftest;
	char label[RDMLABELLENGTH];
	uint8_t labelSize;

} rdm_selftest_description_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t requestedParameter;
	uint8_t pdlSize;
	uint8_t dataType;
	uint8_t commandClass;
	uint8_t type;
	uint8_t unit;
	uint8_t prefix;
	uint32_t minValidValue;
	uint32_t maxValidValue;
	uint32_t defaultValue;
	char description[RDMLABELLENGTH];
	uint8_t labelSize;

} rdm_parameter_description_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t code[2];
} rdm_language_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t slotOffset;
	uint8_t slotType;
	uint16_t slotLabelId;
} rdm_slot_info_get_response_array_t;

typedef struct __attribute__((__packed__))
{
	uint16_t requestedSlot;
	char description[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_slot_desc_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t slotOffset;
	uint8_t slotDefaultValue;
} rdm_slot_default_get_response_array_t;

typedef struct __attribute__((__packed__))
{
	rdm_lamp_on_mode_t mode;
} rdm_lamp_on_mode_response_t;

typedef struct __attribute__((__packed__))
{
	rdm_display_invert_t mode;
} rdm_display_invert_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t mode;
	uint8_t level;
} rdm_preset_playback_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t minimumLevelLowerLimit;
	uint16_t minimumLevelUpperLimit;
	uint16_t maximumLevelLowerLimit;
	uint16_t maximumLevelUpperLimit;
	uint8_t numberOfSupportedCurves;
	uint8_t levelsResolution;
	uint8_t minimumLevelSplitLevelResolution;
} rdm_dimmer_info_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t minimumLevelIncreasing;
	uint16_t minimumLevelDecreasing;
	uint8_t onBelowMinimum;
} rdm_minimum_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t currentCurve;
	uint8_t numberOfCurves;
} rdm_curve_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedCurve;
	char description[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_curve_description_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t currentResponseTime;
	uint8_t numberOfResponseOptions;
} rdm_output_response_time_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedResponseTime;
	char description[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_output_response_time_description_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t currentSetting;
	uint8_t numberOfSettingsAvailable;
} rdm_modulation_frequency_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t requestedModulationSetting;
	uint32_t frequency;
	char description[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_modulation_frequency_description_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t erasing_flash; /* 1 – erase in progress, 0 – no erase in progress */
	uint32_t calibration_compressed_size;
	uint32_t calibration_compressed_crc32;
	uint32_t calibration_data_size;
	uint32_t calibration_data_crc32;
	uint8_t protocol_version;
} rdm_adjustledcalibration_header_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t erasing_flash; /* 1 – erase in progress, 0 – no erase in progress */
	uint32_t calibration_compressed_size;
	uint32_t calibration_compressed_crc32;
	uint32_t calibration_data_size;
	uint32_t calibration_data_crc32;
	uint8_t protocol_version;
	uint64_t calibration_serialB;
	uint8_t calibration_rdmid[6];
	uint64_t calibration_dateB;
	uint64_t calibration_generation_dateB;
	uint8_t calibration_version[3];
	uint8_t color_control_status;
	uint8_t color_control_version[3];

} rdm_adjustledcalibration_protocollv1;

typedef struct __attribute__((__packed__))
{
	uint8_t erasing_flash; /* 1 – erase in progress, 0 – no erase in progress */
	uint32_t calibration_compressed_size;
	uint32_t calibration_compressed_crc32;
	uint32_t calibration_data_size;
	uint32_t calibration_data_crc32;
	uint8_t protocol_version;
	uint64_t calibration_serial;
	uint8_t calibration_rdmid[6];
	uint64_t calibration_date;
	uint64_t calibration_generation_date;
	uint8_t calibration_version[4];
	uint8_t color_control_status;
	uint8_t color_control_version[4];
} rdm_adjustledcalibration_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint32_t color_control_infos[5];
	uint8_t color_info_count;
} rdm_adjustledcalibration_colorinfos_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t code[2];
} rdm_language_set_t;

typedef struct __attribute__((__packed__))
{
	uint16_t scene;
	uint16_t upFadeTime;
	uint16_t downFadeTime;
	uint16_t waitTime;
} rdm_capture_preset_set_t;

typedef struct __attribute__((__packed__))
{
	uint8_t pcbIndex; /* 1 – erase in progress, 0 – no erase in progress */
	uint8_t ledIndex;
	uint8_t dataLength;
	uint8_t debugData[200];
} rdm_adjustledcalibration_debug_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint16_t index;
	uint32_t chunk_crc32;
} rdm_adjustledcalibration_send_set_t;

typedef enum {
	CAL_OK               = 0,
	CAL_ERROR_CHECKSUM   = 1,
	CAL_ERROR_FLASH      = 2,
	CAL_ERROR_NOT_ERASED = 3
} custom_adjust_cal_send_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t protocollVersion;
	uint16_t deviceModelId;
	uint64_t serial;
	uint8_t iqControllerFirmware[4];
	uint8_t iqControllerBootloaderFirmware[4];
	uint8_t fixtureFirmware[4];
	uint8_t fixtureBootloaderFirmware[4];
	uint8_t iqControllerCpuId[8];
	uint8_t fixtureMainCpuId[12];
	uint8_t battery;
	rdm_iq_power_supply_state_t powerSupplyState;
	uint8_t reserved;
	rdm_iq_inputsource_t inputSource;
	rdm_iq_input_state_t inputState;
	uint8_t inputQuality;
	uint16_t dmxStartaddress;
	uint8_t dmxPersonality;
	uint16_t dmxFootprint;
	uint8_t errorCount : 4;
	uint8_t warningCount : 4;
	uint16_t supportedInputSource;
	uint8_t featureSleepMode;
	uint8_t featureShippingMode;
	uint8_t featureEmergency;
	uint8_t featureRuntimeSelection;
	uint8_t featureAntitheftMode;
} rdm_iq_get_response_t;

typedef struct __attribute__((__packed__))
{
	char label[RDMLABELLENGTH];
	uint8_t labelSize;
} rdm_custom_label_get_response_t;

typedef struct __attribute__((__packed__))
{
	uint8_t access_code[6];
	uint32_t compressed_size;
	uint32_t compressed_crc32;
	uint32_t data_size;
	uint32_t data_crc32;
} rdm_adjustledcalibration_set_t;

typedef struct __attribute__((__packed__))
{
	uint8_t licenseData[32];
} rdm_colorconverter_license_t;

typedef enum {
	RDM_CC_CALIBRATION_WRITE,
	RDM_CC_CALIBRATION_SAVE,
} rdm_colorconverter_cal_command_t;

typedef enum {
	RDM_CUSTOM_DFU_STATUS_CODE_OK = 0,
	RDM_CUSTOM_DFU_STATUS_CODE_RETRY = 1,
	RDM_CUSTOM_DFU_STATUS_CODE_PROCESS_CRC = 2,
	RDM_CUSTOM_DFU_STATUS_CODE_MISSING_PACKETS = 3,
	RDM_CUSTOM_DFU_STATUS_CODE_FLASH_ERROR = 4,
	RDM_CUSTOM_DFU_STATUS_CODE_NOT_STARTED = 5,
	RDM_CUSTOM_DFU_STATUS_CODE_CRC_ERROR = 6,
	RDM_CUSTOM_DFU_STATUS_CODE_WRONG_SIGNATURE = 6,
	RDM_CUSTOM_DFU_STATUS_CODE_TIMEOUT = 7,
}rdm_custom_response_dfu_status_code_t;

typedef struct __attribute__((__packed__))
{
	rdm_custom_response_dfu_status_code_t statusCode;
	uint8_t eraseTimeS;
	uint8_t waitTimeMs;
} rdm_custom_response_dfu_start_t;


typedef struct __attribute__((__packed__))
{
        uint16_t deviceCount;
        bool listChange;
} rdm_proxy_device_count_response_t;

#endif
