/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2024 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "bootloader_update.h"
#include "string.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
/* USER CODE BEGIN PFP */
static void HardwareGpioSetSignalLed(bool enable);
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */
#ifdef RELEASEBL
	/* Only needed if VTOR is not availabe */
	/* Relocate the vector table */
	  volatile uint32_t *VectorTable = (volatile uint32_t *)0x20000000;
	  for(int i = 0; i < 48; i++)
	  {
		VectorTable[i] = *(__IO uint32_t*)(USER_FLASH_ADDRESS_APP + (i<<2));
	  }
	  __HAL_RCC_AHB_FORCE_RESET();
	  __HAL_RCC_SYSCFG_CLK_ENABLE();
	  __HAL_RCC_AHB_RELEASE_RESET();
	   __DSB();
	   __HAL_SYSCFG_REMAPMEMORY_SRAM();
	  __DSB();
	  __ISB();

	  /* VTOR is available*/
	  //SCB->VTOR = USER_FLASH_ADDRESS_APP;
#endif
  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  /* USER CODE BEGIN 2 */
  // Signal Start Replacing Bootloader
  HardwareGpioSetSignalLed(true);
  HAL_Delay(1000);
  HardwareGpioSetSignalLed(false);
  HAL_Delay(1000);
  HardwareGpioSetSignalLed(true);
  HAL_Delay(1000);

  UpdateBootloader();
  HAL_NVIC_SystemReset();
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL12;
  RCC_OscInitStruct.PLL.PREDIV = RCC_PREDIV_DIV1;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  /* USER CODE BEGIN MX_GPIO_Init_1 */
  /* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOB_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin : LED_Pin */
  GPIO_InitStruct.Pin = LED_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(LED_GPIO_Port, &GPIO_InitStruct);

  /* USER CODE BEGIN MX_GPIO_Init_2 */
  /* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */
bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer)
{
	HAL_StatusTypeDef ret;
	if( HAL_FLASH_Unlock() != HAL_OK )
	{
		return false;
	}
	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	for( uint32_t i = 0u; i < lengthAligned; i++)
	{
		ret = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD,
						   placeAddress + (i * USER_FLASH_BYTEALIGNMENT),
						   *((uint16_t*)(&((uint8_t*)writeBuffer)[i * USER_FLASH_BYTEALIGNMENT])));
		if( ret != HAL_OK )
		{
		 return false;
		}
	}

	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	if( ret != HAL_OK )
	{
		return false;
	}

	ret = HAL_FLASH_Lock();
	if( ret != HAL_OK )
	{
		return false;
	}
	return true;
}

bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages)
{
	HAL_StatusTypeDef ret;
	FLASH_EraseInitTypeDef EraseInitStruct;
	uint32_t SectorError;
	
	if( HAL_FLASH_Unlock() != HAL_OK )
	{
		return false;
	}
	ret = FLASH_WaitForLastOperation(HAL_MAX_DELAY);

	EraseInitStruct.TypeErase   = FLASH_TYPEERASE_PAGES;
	EraseInitStruct.PageAddress        = flashPageAddress;
	// Pages needed for Application
	EraseInitStruct.NbPages     = flashPages;
	// clear all flags before you write it to flash
	//__HAL_FLASH_CLEAR_FLAG(FLASH_FLAG_EOP | FLASH_FLAG_OPERR |
	//			FLASH_FLAG_WRPERR | FLASH_FLAG_PGAERR | FLASH_FLAG_PGPERR);

	if(HAL_FLASHEx_Erase( &EraseInitStruct, &SectorError )!= HAL_OK )
	{
		return false;
	}

	//Check if the FLASH_FLAG_BSY.
	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	if( ret != HAL_OK )
	{
		return false;
	}
	ret = HAL_FLASH_Lock();
	if( ret != HAL_OK )
	{
		return false;
	}
	return true;
	(void)flashStartPage;
}

static void HardwareGpioSetSignalLed(bool enable)
{
	HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, (GPIO_PinState)enable);
}

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
