/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2024 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "dfu_update.h"
#include "string.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
SPI_HandleTypeDef hspi1;
DMA_HandleTypeDef hdma_spi1_rx;
DMA_HandleTypeDef hdma_spi1_tx;

/* USER CODE BEGIN PV */
/* Buffer for DMA SPI Communication -  用于 DMA SPI 通信的缓冲区*/
static uint8_t dmaBufRx[520];
static uint16_t dmaBufLength = 0;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_SPI1_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */
  bool timeout = DfuCheckBootReason();
  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_SPI1_Init();
  /* USER CODE BEGIN 2 */
  /* DFU Request. Receive the data from the SPI and flash
     * DFU 请求。接收�?�自SPI和Flash的数�?�*/
	if(DfuDownloadFlash(timeout) != DFU_OK)
	{
		/* Error. Don't process.
		* 错误。�?处�?�。
		* */
		HAL_NVIC_SystemReset();
	}
	else
	{
		/* Reset then start new application  �?置然�?��?�动新应用程�?*/
		HAL_NVIC_SystemReset();
	}
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL12;
  RCC_OscInitStruct.PLL.PREDIV = RCC_PREDIV_DIV1;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief SPI1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_SPI1_Init(void)
{

  /* USER CODE BEGIN SPI1_Init 0 */

  /* USER CODE END SPI1_Init 0 */

  /* USER CODE BEGIN SPI1_Init 1 */

  /* USER CODE END SPI1_Init 1 */
  /* SPI1 parameter configuration*/
  hspi1.Instance = SPI1;
  hspi1.Init.Mode = SPI_MODE_MASTER;
  hspi1.Init.Direction = SPI_DIRECTION_2LINES;
  hspi1.Init.DataSize = SPI_DATASIZE_8BIT;
  hspi1.Init.CLKPolarity = SPI_POLARITY_LOW;
  hspi1.Init.CLKPhase = SPI_PHASE_1EDGE;
  hspi1.Init.NSS = SPI_NSS_SOFT;
  hspi1.Init.BaudRatePrescaler = SPI_BAUDRATEPRESCALER_32;
  hspi1.Init.FirstBit = SPI_FIRSTBIT_MSB;
  hspi1.Init.TIMode = SPI_TIMODE_DISABLE;
  hspi1.Init.CRCCalculation = SPI_CRCCALCULATION_DISABLE;
  hspi1.Init.CRCPolynomial = 7;
  hspi1.Init.CRCLength = SPI_CRC_LENGTH_DATASIZE;
  hspi1.Init.NSSPMode = SPI_NSS_PULSE_ENABLE;
  if (HAL_SPI_Init(&hspi1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN SPI1_Init 2 */

  /* USER CODE END SPI1_Init 2 */

}

/**
  * Enable DMA controller clock
  */
static void MX_DMA_Init(void)
{

  /* DMA controller clock enable */
  __HAL_RCC_DMA1_CLK_ENABLE();

  /* DMA interrupt init */
  /* DMA1_Channel2_3_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA1_Channel2_3_IRQn, 1, 0);
  HAL_NVIC_EnableIRQ(DMA1_Channel2_3_IRQn);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
/* USER CODE BEGIN MX_GPIO_Init_1 */
/* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(SPI_CS_GPIO_Port, SPI_CS_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(FIXTURE_IS_ON_GPIO_Port, FIXTURE_IS_ON_Pin, GPIO_PIN_SET);

  /*Configure GPIO pin : SPI_CS_Pin */
  GPIO_InitStruct.Pin = SPI_CS_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(SPI_CS_GPIO_Port, &GPIO_InitStruct);

  /*Configure GPIO pins : LED_Pin FIXTURE_IS_ON_Pin */
  GPIO_InitStruct.Pin = LED_Pin|FIXTURE_IS_ON_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /*Configure GPIO pin : IRQ_Pin */
  GPIO_InitStruct.Pin = IRQ_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_IT_RISING_FALLING;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(IRQ_GPIO_Port, &GPIO_InitStruct);

  /* EXTI interrupt init*/
  HAL_NVIC_SetPriority(EXTI4_15_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(EXTI4_15_IRQn);

/* USER CODE BEGIN MX_GPIO_Init_2 */
/* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */

bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer)
{
	__disable_irq();
	HAL_StatusTypeDef ret;
	if( HAL_FLASH_Unlock() != HAL_OK )
	{
		__enable_irq();
		return false;
	}
	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	for( uint32_t i = 0u; i < lengthAligned; i++)
	{
		ret = HAL_FLASH_Program(FLASH_TYPEPROGRAM_HALFWORD,
						   placeAddress + (i * USER_FLASH_BYTE_ALIGNMENT),
						   *((uint16_t*)(&((uint8_t*)writeBuffer)[i * USER_FLASH_BYTE_ALIGNMENT])));
		if( ret != HAL_OK )
		{
			__enable_irq();
			return false;
		}
	}

	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	if( ret != HAL_OK )
	{
		__enable_irq();
		return false;
	}

	ret = HAL_FLASH_Lock();
	if( ret != HAL_OK )
	{
		__enable_irq();
		return false;
	}
	__enable_irq();
	return true;
}

/**
 * @brief Erases a specified range of flash memory pages.
 *
 * This function performs a hardware-based flash erase operation on a
 * specified range of flash pages, starting from the given flash page address.
 * The flash pages are erased starting from the provided starting page or flash page address
 * depending on the specific flash function used.
 *
 * @param flashPageAddress The starting address of the flash page to begin erasing.
 * @param flashStartPage The starting page index for the erase operation.
 * @param flashPages The number of pages to erase starting from the specified page.
 *
 * @return bool Returns true if the erase operation was successful,
 *              false if an error occurred.
 *
 */
bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages)
{
	HAL_StatusTypeDef ret;
	if( HAL_FLASH_Unlock() != HAL_OK )
	{
		return false;
	}
	ret = FLASH_WaitForLastOperation(HAL_MAX_DELAY);

	//Erase the Flash
	FLASH_EraseInitTypeDef EraseInitStruct;
	uint32_t SectorError;

	EraseInitStruct.TypeErase   = FLASH_TYPEERASE_PAGES;
	EraseInitStruct.PageAddress        = flashPageAddress;
	// Pages needed for Application
	EraseInitStruct.NbPages     = flashPages;
	// clear all flags before you write it to flash
	//__HAL_FLASH_CLEAR_FLAG(FLASH_FLAG_EOP | FLASH_FLAG_OPERR |
	//			FLASH_FLAG_WRPERR | FLASH_FLAG_PGAERR | FLASH_FLAG_PGPERR);

	if(HAL_FLASHEx_Erase( &EraseInitStruct, &SectorError )!= HAL_OK )
	{
		return false;
	}

	//Check if the FLASH_FLAG_BSY.
	ret = FLASH_WaitForLastOperation( HAL_MAX_DELAY );

	if( ret != HAL_OK )
	{
		return false;
	}
	ret = HAL_FLASH_Lock();
	if( ret != HAL_OK )
	{
		return false;
	}
	return true;
}

/* SPI Callback Cs implementation for iQ.Controller - iQ.Controller 的 SPI Cs 回调实现*/
void HardwareIqMeshSpiSetCsPin(bool set)
{
	if(set)
	{
		HAL_GPIO_WritePin(SPI_CS_GPIO_Port, SPI_CS_Pin, GPIO_PIN_SET);
	}
	else
	{
		HAL_GPIO_WritePin(SPI_CS_GPIO_Port, SPI_CS_Pin, GPIO_PIN_RESET);
	}
}

/* SPI Callback implementation for iQ.Controller - iQ.Controller 的 SPI 回调实现*/
void HardwareIqMeshSpiSetTxRx(uint8_t *buf, uint16_t length)
{
	dmaBufLength = length;
	// Use IT or DMA
	//HAL_SPI_TransmitReceive_IT(&hspi1, buf, dmaBufRx, dmaBufLength);
	HAL_SPI_TransmitReceive_DMA(&hspi1, buf, dmaBufRx, dmaBufLength);
}

bool HardwareIqMeshGpioReadIrqPin()
{
	return HAL_GPIO_ReadPin(IRQ_GPIO_Port, IRQ_Pin);
}

void HardwareGpioSetFixtureIsOnPin(bool set)
{
	if(set)
	{
		HAL_GPIO_WritePin(FIXTURE_IS_ON_GPIO_Port, FIXTURE_IS_ON_Pin, GPIO_PIN_SET);
	}
	else
	{
		HAL_GPIO_WritePin(FIXTURE_IS_ON_GPIO_Port, FIXTURE_IS_ON_Pin, GPIO_PIN_RESET);
	}
}

void HardwareGpioSetSignalLed(bool set)
{
	if(set)
	{
		HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin,GPIO_PIN_SET);
	}
	else
	{
		HAL_GPIO_WritePin(LED_GPIO_Port, LED_Pin,GPIO_PIN_RESET);
	}
}

uint32_t HardwareTimeMs()
{
	return HAL_GetTick();
}

bool HardwareCheckDFUPin()
{
	// Check if a special combination for example the Button is pressed while starting then you can go into DFU when returning true
	return false;
}

void HardwareSetMsp(uint32_t appStack)
{
	/* Set the application stack pointer */
	__set_MSP(appStack);
}

/* HAL SPI Callback - HAL SPI 回调*/
void HAL_SPI_TxRxCpltCallback(SPI_HandleTypeDef *hspi)
{
	DfuIqMeshSpiTxRxComplete(dmaBufRx, dmaBufLength);
}

/* HAL EXTI Callback for detecting IRQ Pin - 用于检测 IRQ 引脚的 HAL EXTI 回调 */
void HAL_GPIO_EXTI_Callback(uint16_t GPIO_Pin)
{
	if (GPIO_Pin == IRQ_Pin)
	{
		DfuIqMeshIrqPinIrq(HAL_GPIO_ReadPin(IRQ_GPIO_Port, IRQ_Pin));
	}
}

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
