/**
  ******************************************************************************
  * @file           : rdm_implementation.h
  * @brief          : Simple example for showing rdm functionality using the provided rdm library
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef RDM_IMP_H_
#define RDM_IMP_H_

#include <stdbool.h>
#include <stdint.h>

void InitRdmImp(void (*callback)(const uint8_t * msg, uint16_t length, bool sentBreak, uint8_t id));
void RdmImpTask(uint32_t tickMs);
void RdmImpSet(const uint8_t* buf, uint16_t length, uint8_t id);
void RdmImpSetRdmId(uint8_t* rdmId);

/*==============================================================================*/
/* External defined hardware functions                                        	*/
/*==============================================================================*/
extern void HardwareRdmReset(void);
extern uint8_t HardwareRdmGetBatteryStatePercent(void);
extern bool HardwareOutputSettingGpioReadPowerSupplyPin(void);

#endif /* INC_RDM_H_ */
