/**
  ******************************************************************************
  * @file           : output_setting.h
  * @brief          : Simple example for output features like rdm highlight, emergency light
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_OUTPUTSETTING_H_
#define INC_OUTPUTSETTING_H_

#include "stdbool.h"
#include "stdio.h"
#include <stdint.h>

void InitOutputSetting(void);
void OutputSettingTask(uint32_t tickMs);
void OutputSettingGetColorOverride(uint8_t* _red, uint8_t* _green, uint8_t* _blue, bool enabled);

/*==============================================================================*/
/* External defined hardware functions                                        	*/
/*==============================================================================*/

extern bool HardwareOutputSettingGpioReadPowerSupplyPin(void);

#endif /* INC_OUTPUT_H_ */
