/**
  ******************************************************************************
  * @file           : bootloader.h
  * @brief          : Simple example for showing bootloader functionality
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_BOOTLOADER_H_
#define INC_BOOTLOADER_H_

#include <stdbool.h>
#include <stdint.h>

#ifdef RELEASEBL

bool JumpToBootloader(void);
bool CheckNormalBoot(void);

extern void HardwareReset();
extern bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages);
extern bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer);
#endif
#endif /* INC_BOOTLOADER_H_ */
