/* add user code begin Header */
/**
  **************************************************************************
  * @file     main.c
  * @brief    main program
  **************************************************************************
  *                       Copyright notice & Disclaimer
  *
  * The software Board Support Package (BSP) that is made available to
  * download from Artery official website is the copyrighted work of Artery.
  * Artery authorizes customers to use, copy, and distribute the BSP
  * software and its related documentation for the purpose of design and
  * development in conjunction with Artery microcontrollers. Use of the
  * software is governed by this copyright notice and the following disclaimer.
  *
  * THIS SOFTWARE IS PROVIDED ON "AS IS" BASIS WITHOUT WARRANTIES,
  * GUARANTEES OR REPRESENTATIONS OF ANY KIND. ARTERY EXPRESSLY DISCLAIMS,
  * TO THE FULLEST EXTENT PERMITTED BY LAW, ALL EXPRESS, IMPLIED OR
  * STATUTORY OR OTHER WARRANTIES, GUARANTEES OR REPRESENTATIONS,
  * INCLUDING BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
  * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
  *
  **************************************************************************
  */
/* add user code end Header */

/* Includes ------------------------------------------------------------------*/
#include "at32f415_wk_config.h"
#include "wk_debug.h"
#include "wk_exint.h"
#include "wk_spi.h"
#include "wk_dma.h"
#include "wk_gpio.h"
#include "wk_system.h"
#include "stdbool.h"
#include "stdint.h"
#include "at32f415_flash.h"
#include "string.h"

#include "system_implementation.h"
#include "bootloader.h"
#include "defines.h"

/* private includes ----------------------------------------------------------*/
/* add user code begin private includes */

/* add user code end private includes */

/* private typedef -----------------------------------------------------------*/
/* add user code begin private typedef */

/* add user code end private typedef */

/* private define ------------------------------------------------------------*/
/* add user code begin private define */

/* add user code end private define */

/* private macro -------------------------------------------------------------*/
/* add user code begin private macro */

/* add user code end private macro */

/* private variables ---------------------------------------------------------*/
/* add user code begin private variables */
uint16_t dmaBufRx[520/2];
uint16_t dmaBufTx[520/2];
static uint16_t dmaBufLength;
/* add user code end private variables */

/* private function prototypes --------------------------------------------*/
/* add user code begin function prototypes */

/* add user code end function prototypes */

/* private user code ---------------------------------------------------------*/
/* add user code begin 0 */

/* add user code end 0 */

/**
  * @brief main function.
  * @param  none
  * @retval none
  */
int main(void)
{
  /* add user code begin 1 */
#ifdef RELEASEBL
		// Set vector table base address
		SCB->VTOR = USER_FLASH_ADDRESS_APP;

    /* Ensure that the memory system is synchronized */
    __DSB();
    __ISB();
#endif
  /* add user code end 1 */

  /* system clock config. */
  wk_system_clock_config();

  /* config periph clock. */
  wk_periph_clock_config();

  /* init debug function. */
  wk_debug_config();

  /* nvic config. */
  wk_nvic_config();

  /* timebase config. */
  wk_timebase_init();

  /* init dma1 channel1 */
  wk_dma1_channel1_init();

  /* init dma1 channel2 */
  wk_dma1_channel2_init();

  /* init spi1 function. */
  wk_spi1_init();

  /* init exint function. */
  wk_exint_config();

  /* init gpio function. */
  wk_gpio_config();

  /* add user code begin 2 */
  InitSystem();
  /* add user code end 2 */

  while(1)
  {
    /* add user code begin 3 */
		uint32_t tickMs = wk_timebase_get();
		SystemTask(tickMs);
		if((tickMs % 5000) > 250)
		{
			gpio_bits_set(OUT_LED_GPIO_PORT, OUT_LED_PIN);
		}
		else
		{
			gpio_bits_reset(OUT_LED_GPIO_PORT, OUT_LED_PIN);
		}
    /* add user code end 3 */
  }
}

  /* add user code begin 4 */
bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer)
{
	__disable_irq();
	flash_status_type status = FLASH_OPERATE_DONE;
	flash_unlock();

	for(uint16_t index = 0; index < lengthAligned; index++)
	{
		/* wait for operation to be completed */
		status = flash_operation_wait_for(ERASE_TIMEOUT);
		
		if((status == FLASH_PROGRAM_ERROR) || (status == FLASH_EPP_ERROR))
		{
			flash_flag_clear(FLASH_PRGMERR_FLAG | FLASH_EPPERR_FLAG);
		}
		else if(status == FLASH_OPERATE_TIMEOUT)
		{
			flash_lock();
			__enable_irq();
			return false;
		}
		
		status = flash_word_program(placeAddress + (index * USER_FLASH_BYTEALIGNMENT), ((uint32_t*)writeBuffer)[index]);
		if(status != FLASH_OPERATE_DONE)
		{
			flash_lock();
			__enable_irq();
			return false;
		}
		
	}
	
	/* wait for operation to be completed */
	status = flash_operation_wait_for(ERASE_TIMEOUT);
	
	if((status == FLASH_PROGRAM_ERROR) || (status == FLASH_EPP_ERROR))
	{
		flash_flag_clear(FLASH_PRGMERR_FLAG | FLASH_EPPERR_FLAG);
	}
	else if(status == FLASH_OPERATE_TIMEOUT)
	{
		flash_lock();
		__enable_irq();
		return false;
	}
		
	__enable_irq();
	return true;
}


bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages)
{
	flash_status_type status = FLASH_OPERATE_DONE;
	__disable_irq();
	flash_unlock();
	for(uint16_t pages = 0; pages < flashPages; pages++)
	{
		/* wait for operation to be completed */
		status = flash_operation_wait_for(ERASE_TIMEOUT);
		
		if((status == FLASH_PROGRAM_ERROR) || (status == FLASH_EPP_ERROR))
		{
			flash_flag_clear(FLASH_PRGMERR_FLAG | FLASH_EPPERR_FLAG);
		}
		else if(status == FLASH_OPERATE_TIMEOUT)
		{
			flash_lock();
			__enable_irq();
			return false;
		}
		status = flash_sector_erase(flashPageAddress + pages * USER_FLASH_PAGE_SIZE);
		if(status != FLASH_OPERATE_DONE)
		{
			flash_lock();
			__enable_irq();
			return false;
		}
	}
	/* wait for operation to be completed */
	status = flash_operation_wait_for(ERASE_TIMEOUT);

	if((status == FLASH_PROGRAM_ERROR) || (status == FLASH_EPP_ERROR))
	{
		flash_flag_clear(FLASH_PRGMERR_FLAG | FLASH_EPPERR_FLAG);
	}
	else if(status == FLASH_OPERATE_TIMEOUT)
	{
		flash_lock();
		__enable_irq();
		return false;
	}
	
	flash_lock();
	__enable_irq();
	return true;
}


/* SPI Callback Cs implementation for iQ.Controller - iQ.Controller SPI Cs*/
void HardwareIqMeshSpiSetCsPin(bool set)
{
	if(set)
	{
		gpio_bits_set(OUT_SPI_CS_GPIO_PORT, OUT_SPI_CS_PIN);
	}
	else
	{
		gpio_bits_reset(OUT_SPI_CS_GPIO_PORT, OUT_SPI_CS_PIN);
	}
}

bool HardwareIqMeshGpioReadIrqPin()
{
	return gpio_input_data_bit_read(EXTIRQ_GPIO_PORT, EXTIRQ_PIN);
}

void HardwareGpioSetFixtureIsOnPin(bool set)
{
	if(set)
	{
		gpio_bits_set(Out_FixtureIsOn_GPIO_PORT, Out_FixtureIsOn_PIN);
	}
	else
	{
		gpio_bits_reset(Out_FixtureIsOn_GPIO_PORT, Out_FixtureIsOn_PIN);
	}
}
/* SPI Callback implementation for iQ.Controller - iQ.Controller ? SPI ????*/
void HardwareIqMeshSpiSetTxRx(uint8_t *buf, uint16_t length)
{
	if(DMA1_CHANNEL1_BUFFER_SIZE < length)
	{
		while(true){}
	}
	dma_channel_enable(DMA1_CHANNEL1, FALSE);
	dma_channel_enable(DMA1_CHANNEL2, FALSE);
	dmaBufLength = length;
	memcpy(dmaBufTx,buf,length);
	/* config dma channel transfer parameter */
	/* user need to modify define values DMAx_CHANNELy_XXX_BASE_ADDR and DMAx_CHANNELy_BUFFER_SIZE in at32xxx_wk_config.h */
	wk_dma_channel_config(DMA1_CHANNEL1, 
										(uint32_t)&SPI1->dt, 
										DMA1_CHANNEL1_MEMORY_BASE_ADDR, 
										dmaBufLength);
	/* config dma channel transfer parameter */
	/* user need to modify define values DMAx_CHANNELy_XXX_BASE_ADDR and DMAx_CHANNELy_BUFFER_SIZE in at32xxx_wk_config.h */
	wk_dma_channel_config(DMA1_CHANNEL2, 
										(uint32_t)&SPI1->dt, 
										DMA1_CHANNEL2_MEMORY_BASE_ADDR, 
										dmaBufLength);
	dma_channel_enable(DMA1_CHANNEL1, TRUE);
	dma_channel_enable(DMA1_CHANNEL2, TRUE);
}



void HardwareGpioSetSignalLed(bool set)
{
	// Not necessary.
}

uint32_t HardwareTimeMs()
{
	return wk_timebase_get();
}



void HardwareSetMsp(uint32_t appStack)
{
	/* Set the application stack pointer */
	__set_MSP(appStack);
}



/* HAL SPI Callback - HAL SPI ??*/
void SPI_DMA_TxTransferCompleteCallback()
{
	// Do not use. This will fire too early. use Rx instead
}
void SPI_DMA_RxTransferCompleteCallback()
{
	SystemIqMeshSpiTxRxComplete((uint8_t*)dmaBufRx, dmaBufLength);
}

/* HAL EXTI Callback for detecting IRQ Pin - ???? IRQ ??? HAL EXTI ?? */
void EXINT_IrqLineCallback()
{
	SystemIqMeshIrqPinIrq(gpio_input_data_bit_read(EXTIRQ_GPIO_PORT, EXTIRQ_PIN));
}

extern void HardwareReset()
{
	NVIC_SystemReset();
}

bool HardwareSystemGpioReadMainWakeUpPin(void)
{
	return gpio_input_data_bit_read(InWakeUp_GPIO_PORT, InWakeUp_PIN);
}

void HardwareSystemEnterSleep(void)
{
	// Not used
	//HAL_PWR_EnterSLEEPMode(PWR_MAINREGULATOR_ON, PWR_SLEEPENTRY_WFI);
}

void HardwareOutputGpioSetPowerEnablePin(bool enable)
{
	// When external harware which is power hungry can be enabled or disabled
	//HAL_GPIO_WritePin(POWER_ENABLE_GPIO_Port, POWER_ENABLE_Pin, (GPIO_PinState)enable);
}

bool HardwareOutputSettingGpioReadPowerSupplyPin(void)
{
	return true;
	// Only needed when Battery is used
	//return HAL_GPIO_ReadPin(PPR_GPIO_Port, PPR_Pin);
}

extern uint8_t HardwareRdmGetBatteryStatePercent(void)
{
	// Only needed when Battery is used
	return 0;
}

bool HardwareOutputTimPwmStart(uint16_t* data, uint16_t length)
{
	// Here you can control the output for example an led pwm
	// Start PWM
	return true;
}

void HardwareOutputTimPwmStop()
{
	// Stop PWM
}

void HardwareRdmReset(void)
{
	NVIC_SystemReset();
}

  /* add user code end 4 */
