/**
  **************************************************************************
  * @file     mouse_desc.h
  * @brief    usb mouse descriptor header file
  **************************************************************************
  *                       Copyright notice & Disclaimer
  *
  * The software Board Support Package (BSP) that is made available to
  * download from Artery official website is the copyrighted work of Artery.
  * Artery authorizes customers to use, copy, and distribute the BSP
  * software and its related documentation for the purpose of design and
  * development in conjunction with Artery microcontrollers. Use of the
  * software is governed by this copyright notice and the following disclaimer.
  *
  * THIS SOFTWARE IS PROVIDED ON "AS IS" BASIS WITHOUT WARRANTIES,
  * GUARANTEES OR REPRESENTATIONS OF ANY KIND. ARTERY EXPRESSLY DISCLAIMS,
  * TO THE FULLEST EXTENT PERMITTED BY LAW, ALL EXPRESS, IMPLIED OR
  * STATUTORY OR OTHER WARRANTIES, GUARANTEES OR REPRESENTATIONS,
  * INCLUDING BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
  * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
  *
  **************************************************************************
  */

/* define to prevent recursive inclusion -------------------------------------*/
#ifndef __MOUSE_DESC_H
#define __MOUSE_DESC_H

#ifdef __cplusplus
extern "C" {
#endif

#include "mouse_class.h"
#include "usbd_core.h"

/** @addtogroup AT32F415_middlewares_usbd_class
  * @{
  */

/** @addtogroup USB_mouse_desc
  * @{
  */

/** @defgroup USB_mouse_desc_definition
  * @{
  */

/**
  * @brief usb bcd number define
  */
#define MOUSE_BCD_NUM                      0x0110

/**
  * @brief usb vendor id and product id define
  */
#define USBD_MOUSE_VENDOR_ID             0x2E3C
#define USBD_MOUSE_PRODUCT_ID            0x5710

/**
  * @brief usb descriptor size define
  */
#define USBD_MOUSE_CONFIG_DESC_SIZE            34
#define USBD_MOUSE_SIZ_REPORT_DESC             74
#define USBD_MOUSE_SIZ_STRING_LANGID           4
#define USBD_MOUSE_SIZ_STRING_SERIAL           0x1A

/**
  * @brief usb string define(vendor, product configuration, interface)
  */
#define USBD_MOUSE_DESC_MANUFACTURER_STRING    "Artery"
#define USBD_MOUSE_DESC_PRODUCT_STRING         "Mouse"
#define USBD_MOUSE_DESC_CONFIGURATION_STRING   "Mouse Config"
#define USBD_MOUSE_DESC_INTERFACE_STRING       "Mouse Interface"

/**
  * @brief usb hid endpoint interval define
  */
#define MOUSE_BINTERVAL_TIME                0x0A

/**
  * @brief usb mcu id address deine
  */
#define         MCU_ID1                   (0x1FFFF7E8)
#define         MCU_ID2                   (0x1FFFF7EC)
#define         MCU_ID3                   (0x1FFFF7F0)

/**
  * @}
  */
extern uint8_t g_usbd_mouse_report[USBD_MOUSE_SIZ_REPORT_DESC];
extern uint8_t g_mouse_usb_desc[9];
extern usbd_desc_handler mouse_desc_handler;

/**
  * @}
  */

/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif


