/**
  ******************************************************************************
  * @file           : dfu_update.h
  * @brief          : Simple example for showing dfu update functionality
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_DFU_UPDATE_H_
#define INC_DFU_UPDATE_H_

#include <stdbool.h>
#include <stdio.h>
#include <stdint.h>

/* Change this information regarding to the implementation - 更改此有关实施的信息 ----------*/

/*Please Modifiy these two defines depending on your fixture  */
#define BOOTLOADER_RDM_MANUFACTURER 	0xF00A
#define BOOTLOADER_RDM_MODEL_ID 		0x2

/* Please Modify these depending on your IC*/
#ifndef FLASH_ADDR_BASE
#define FLASH_ADDR_BASE						0x08000000
#endif
#ifndef FLASH_ADDR_BOOTLOADER
#define FLASH_ADDR_BOOTLOADER  		0x08000000  	// Flash Address where the bootloader starts. This is normally the startaddress of the flash
#endif
#ifndef FLASH_ADDR_CONFIG
#define FLASH_ADDR_CONFIG					0x08004000		// Then we need a page for the application information. We will add this directly after the bootloader and before the application
#endif
#ifndef FLASH_PAGE_CONFIG
#define FLASH_PAGE_CONFIG					8							// Depending of the implementation of the flash maybe the flash address or the page is needed.
#endif
#ifndef FLASH_ADDR_APP
#define FLASH_ADDR_APP						0x08004800		// Flash Address where the application starts
#endif
#ifndef FLASH_ADDR_END
#define FLASH_ADDR_END						0x0803FFFF		// Flash Address where the flash ends
#endif
#ifndef FLASHPAGE_SIZE
#define FLASHPAGE_SIZE						0x800					// Size of a flash page
#endif
#ifndef USER_FLASH_BYTE_ALIGNMENT
#define USER_FLASH_BYTE_ALIGNMENT	4							// Flash Write Operation Alignment in Bytes
#endif
/* ------------------------------------------------------------*/

#define BOOTLOADER_VERSION_MAJOR 		1
#define BOOTLOADER_VERSION_MINOR 		1
#define BOOTLOADER_VERSION_PATCH 		2
#define BOOTLOADER_VERSION_RELEASE 		255

static const uint8_t rdm_id[] = {BOOTLOADER_RDM_MANUFACTURER >> 8 ,(uint8_t)BOOTLOADER_RDM_MANUFACTURER,0x00,0x00,0x00,0x00};

static const char SIGNATURE[20] = {'V','I','S','I','O','N','D','F','U',BOOTLOADER_RDM_MANUFACTURER >> 8,(uint8_t)BOOTLOADER_RDM_MANUFACTURER,
									BOOTLOADER_RDM_MODEL_ID >> 8,BOOTLOADER_RDM_MODEL_ID, 0,0,0,'#','D','F','U'};

/* ---------------------------------------------------------------------------------------*/

#define FLASH_APP_LENGTH		  		FLASH_ADDR_END - FLASH_ADDR_APP

#define BOOT_FIRST_TIME       	   ( 0xFFFFFFFF )      //First time boot
#define BOOT_NORMAL		           ( 0xBEEFFEED )      //Normal Boot
#define BOOT_DFU_REQUEST           ( 0xDEADBEEF )      //OTA request by application

typedef enum
{
  DFU_OK       = 0,    // Success
  DFU_ERR      = 1,    // Failure
  DFU_TIMEOUT  = 2,    // Failure
}dfu_response_t;

typedef enum
{
  DFU_STATE_IDLE    = 0,
  DFU_STATE_START   = 1,
  DFU_STATE_DATA    = 2,
  DFU_STATE_FINISH  = 3,
  DFU_STATE_ABORT  = 4,
}dfu_state_t;

typedef struct
{
  uint8_t signature[20];
  uint32_t fileSize;
  uint32_t fileCRC;
  uint8_t firmwareVersion[4];
} dfu_file_header_t;

typedef struct
{
    uint32_t  reboot_cause;
    uint8_t bootloaderVersion[4];
    dfu_file_header_t file;
} dfu_config_t;


bool DfuCheckBootReason(void);
dfu_response_t DfuDownloadFlash(bool timeout);
void DfuIqMeshSpiTxRxComplete(uint8_t* data, uint16_t length);
void DfuIqMeshIrqPinIrq(bool set);

extern void HardwareSetMsp(uint32_t appStack);
extern bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages);
extern bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer);
extern void HardwareGpioSetFixtureIsOnPin(bool set);
extern void HardwareGpioSetSignalLed(bool set);
extern uint32_t HardwareTimeMs(void);
extern bool HardwareCheckDFUPin(void);


#endif /* INC_DFU_UPDATE_H_ */
