/**
  ******************************************************************************
  * @file           : bootloader.c
  * @brief          : Simple example for showing how to jump to the bootloader
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/
#ifdef RELEASEBL

/*==============================================================================*/
/* Includes                                                                  	*/
/*==============================================================================*/
#include "bootloader.h"
#include "managedflash.h"
#include "defines.h"

/*==============================================================================*/
/* Defines & Macros                                                           	*/
/*==============================================================================*/

/*==============================================================================*/
/* Private functions                                                          	*/
/*==============================================================================*/

/*==============================================================================*/
/* Private variables                                                          	*/
/*==============================================================================*/

/*==============================================================================*/
/* Function definitions                                                     	  */
/*==============================================================================*/
bool JumpToBootloader(void)
{
	/* Get configuration from flash - 从闪存获取配置 */
	dfu_config_t config = *((dfu_config_t*) (USER_FLASH_ADDRESS_CONFIG));

	if(config.reboot_cause != BOOT_NORMAL)
	{
		/* No bootloader available if not written correct - 如果写入不正确，则无法使用引导加载程序 */
		/* Cannot start bootloader so abort - 无法启动引导加载程序，因此中止 */
		return false;
	}
	/* Set Reboot cause to DFU request - 将重启原因设置为 DFU 请求*/
	config.reboot_cause = BOOT_DFU_REQUEST;

	if(!HardwareEraseFlash(USER_FLASH_ADDRESS_CONFIG, USER_FLASH_PAGE_CONFIG, 1))
	{
		return false;
	}
	uint16_t lengthAligned = sizeof(dfu_config_t) / USER_FLASH_BYTEALIGNMENT;
	if((sizeof(dfu_config_t) % USER_FLASH_BYTEALIGNMENT) != 0)
	{
		lengthAligned++;
	}
	if(!HardwareWriteFlash(USER_FLASH_ADDRESS_CONFIG,lengthAligned,(uint8_t*)&config))
	{
		return false;
	}

	/* Restart - 重新开始 */
	HardwareReset();

	return false;
}
#endif
