/**
  ******************************************************************************
  * @file           : variables.c
  * @brief          : Simple example for showing dmx functionality
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/


#ifndef INC_VARIABLES_H_
#define INC_VARIABLES_H_

#include "defines.h"
#include "stdbool.h"
#include "rdmpid.h"

typedef void (*notify_callback_t)(void);

void InitVariables(void);
void VariablesTask(void);

//Serial Number
const uint64_t* get_serial(void);
void set_serial(uint64_t serial);
void deregister_notify_serial(notify_callback_t callback);
void register_notify_serial(notify_callback_t callback);

//Serial Number
rdmid_t get_rdmid(void);

//Device Label
const device_label_t* get_deviceLabel(void);
void set_deviceLabel(device_label_t label);

//Device Hours
const rdm_counter_t* get_counter(void);
void set_counter(rdm_counter_t counter);

// SystemState Information
void deregister_notify_systemState(notify_callback_t callback);
void register_notify_systemState(notify_callback_t callback);
const system_state_t* get_systemState(void);
void set_systemState(system_state_t data);

// Input Source
const input_source_t* get_inputSource(void);
void set_inputSource(input_source_t data);

const dmx_settings_t* get_dmxSettings(void);
bool set_dmxSettings(dmx_settings_t settings);


//Factory Defaults
bool get_factoryDefault(void);
void set_factoryDefault(void);


const features_t* get_features(void);
void set_features(features_t data);

// Rdm Identify
const bool* get_rdmIdentify(void);
void set_rdmIdentify(bool enabled);


#endif /* INC_VARIABLES_H_ */

