/**
  ******************************************************************************
  * @file           : system_implementation.h
  * @brief          : Simple example for showing rdm functionality using the provided rdm library
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_SYSTEM_IMPLEMENTATION_H_
#define INC_SYSTEM_IMPLEMENTATION_H_

#include "string.h"
#include "stdint.h"
#include "stdbool.h"

void InitSystem(void);
void SystemTask(uint32_t tickMs);
void SystemIqMeshSpiTxRxComplete(uint8_t* receivedDataBuffer, uint16_t receivedDataLength);
void SystemIqMeshIrqPinIrq(bool set);
void SystemIqMeshMainWakeUpPinIrq(bool set);
void SystemButtonPinIrq(bool set);
void SystemButtonWaitTimeElapsed(void);

/*==============================================================================*/
/* External defined hardware functions                                        	*/
/*==============================================================================*/

extern bool HardwareSystemGpioReadMainWakeUpPin(void);
extern void HardwareSystemEnterSleep(void);
extern void HardwareGpioSetFixtureIsOnPin(bool enable);
extern void HardwareGpioSetSignalLed(bool enable);

#endif /* INC_SYSTEM_IMPLEMENTATION_H_ */
