/**
  ******************************************************************************
  * @file           : output.h
  * @brief          : Simple example for setting output
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_OUTPUT_H_
#define INC_OUTPUT_H_

#include "stdbool.h"
#include "stdint.h"

void InitOutput(void);
bool OutputTask(uint32_t tickMs);
void OutputEnable(bool enable);
void OutputSetRaw(uint8_t* _red,uint8_t* _green,uint8_t* _blue, bool animation);

/*==============================================================================*/
/* External defined hardware functions                                        	*/
/*==============================================================================*/

extern void HardwareOutputGpioSetPowerEnablePin(bool enable);
extern bool HardwareOutputTimPwmStart(uint16_t* data, uint16_t length);
extern void HardwareOutputTimPwmStop(void);

#endif /* INC_OUTPUT_H_ */
