/**
  ******************************************************************************
  * @file           : defines.h
  * @brief          : Global definitions
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

/*==============================================================================*/
/* Includes                                                                  	*/
/*==============================================================================*/

#ifndef INC_DEFINES_H_
#define INC_DEFINES_H_

#include "rdmpid.h"

/* Please modify depending on your project */

// RDM User
#define RDM_MANUFACTURER					0xF00A // Example Manufacturer
#define RDM_DEVICEMODEL_ID 					2
#define RDM_PRODUCT_CATEGORY 				1
#define RDM_DEVICE_MODEL_DESCRIPTION 		"External Example"
#define RDM_MANUFACTURER_NAME 				"KKT"
#define RDM_PRODUCT_DETAIL_LED 				0x0004//PRODUCT_DETAIL_LED;
#define RDM_PERSONALITY_COUNT 				3
#define RDM_SENSOR_COUNT 					0

extern const uint8_t RDM_FOOTPRINTS[];
extern const char RDM_PERSONALITY_NAMES[][RDMLABELLENGTH];
extern const char RDM_DEFAULT_DEVICE_LABEL[];

// DMX User
#define DMX_DEFAULT_STARTADDRESS 			1
#define DMX_DEFAULT_PERSONALITY 			1
#define DMX_DEFAULT_DIMMER_CURVE 			1
#define DMX_DEFAULT_INPUT_SOURCE 			0

// Feature Support
#define FEATURE_EMERGENCY_SUPPORT 			0
#define FEATURE_RUNTIMESELECTION_SUPPORT 	0
#define FEATURE_SHIPPINGMODE_SUPPORT 		0
#define FEATURE_ANTITHEFTMODE_SUPPORT 		1
#define FEATURE_SLEEP_SUPPORT 				1

// Supported InputSources
#define SUPPORTEDINPUTSOURCE_IQMESH 		1
#define SUPPORTEDINPUTSOURCE_DMX 			0
#define SUPPORTEDINPUTSOURCE_CRMXWDMX 		0
#define SUPPORTEDINPUTSOURCE_ARTNET 		0
#define SUPPORTEDINPUTSOURCE_SACN 			0

#define OUTPUT_LED_COUNT 					9
#define OUTPUT_LED_COLORS 					3

// Power Draw for RunTimeSelection
#define BATTERY_SUPPORT						0
#define BATTERY_CAPACITY_mWH				0
#define LED_POWER_RED_mW				 	1578
#define LED_POWER_GREEN_mW				 	3150
#define LED_POWER_BLUE_mW				 	2600

/* -------------------------------------------------------------------------- */

#define MINUTES_MS	60000

#define BOOT_FIRST_TIME       	   ( 0xFFFFFFFF )      //First time boot
#define BOOT_NORMAL		           ( 0xBEEFFEED )      //Normal Boot
#define BOOT_DFU_REQUEST           ( 0xDEADBEEF )      //DFU request by application

typedef enum
{
	INPUT_SOURCE_IQ_MESH,
	INPUT_SOURCE_DMX,
	INPUT_SOURCE_CRMX
} input_source_t;

typedef enum
{
	SYSTEM_STATE_NORMAL,
	SYSTEM_STATE_SLEEP,
	SYSTEM_STATE_WAKEUP,
	SYSTEM_STATE_TURN_OFF,
	SYSTEM_STATE_OFF
} system_state_t;

typedef struct
{
	char array[RDMLABELLENGTH];
} device_label_t;

typedef struct
{
	uint32_t deviceCounterMinutes;
	uint32_t sourceCounterMinutes;
	uint32_t devicePowercycle;
} rdm_counter_t;

typedef enum
{
	DIMMER_CURVE_LINEAR,
	DIMMER_CURVE_QUADRATIC
} dimmer_curve_t;

typedef struct
{
	uint8_t dmxPersonality;
	dimmer_curve_t dmxDimmerCurve;
	uint16_t dmxStartadress;
} dmx_settings_t;

typedef struct
{
rdm_iq_battery_runtime_t runtimeSet;
bool emergencyMode;
rdm_iq_antitheft_t antitheftMode;
} features_t;

typedef struct
{
	uint8_t array[6];
} rdmid_t;

typedef struct
{
  uint8_t signature[20];
  uint32_t fileSize;
  uint32_t fileCRC;
  uint8_t firmwareVersion[4];
} DFU_FILE_HEADER_;

typedef struct
{
    uint32_t  reboot_cause;
    uint8_t bootloaderVersion[4];
    DFU_FILE_HEADER_ file;
    uint32_t checkedCRC;
} dfu_config_t;

#endif /* INC_DEFINES_H_ */
