#ifndef SPIIQMESH_H__
#define SPIIQMESH_H__

#include <stdbool.h>
#include <stdint.h>
#include <string.h>

#include "libIqMeshSpiInterface.h"

typedef struct
{
	uint16_t cmd;
	uint16_t length;
} spi_message_header_t;

typedef struct
{
	void (*Finish)(bool success);
	void (*IrQFlag)(void);
	void (*IrQ)(uint8_t irq);
	void (*DataRx)(spi_message_header_t msg, uint8_t *buffer);
	void (*SPISetTxRx)(uint8_t *buf, uint16_t length);
	void (*SPISetCs)(bool set);
} spi_iqmesh_callbacks_t;

void spiIqMesh_init(spi_iqmesh_callbacks_t callbacks);
bool spiIqMesh_IsIdle();
bool spiIqMesh_Task(uint32_t tickMs);
bool spiIqMesh_PrepareData(spi_message_header_t header, uint8_t **bufPointer);
bool spiIqMesh_SetData(bool irqSet);
void spiIqMesh_extIrqInterupt(iqmesh_irq_edge_t edge);
void spiIqMesh_extSpiEvent(spi_event_t event, uint8_t *buffer, uint16_t length);

#endif
