#ifndef LIBRUNTIME_H__
#define LIBRUNTIME_H__

#include <stdbool.h>
#include <stdint.h>

#define MAX_DIECOUNT 6

typedef enum
{
  BATTERYRUNTIME_FULLOUTPUT = 0,
  BATTERYRUNTIME_1HOURS = 1,
  BATTERYRUNTIME_2HOURS = 2,
  BATTERYRUNTIME_3HOURS = 3,
  BATTERYRUNTIME_4HOURS = 4,
  BATTERYRUNTIME_5HOURS = 5,
  BATTERYRUNTIME_6HOURS = 6,
  BATTERYRUNTIME_7HOURS = 7,
  BATTERYRUNTIME_8HOURS = 8,
  BATTERYRUNTIME_9HOURS = 9,
  BATTERYRUNTIME_10HOURS = 10,
  BATTERYRUNTIME_11HOURS = 11,
  BATTERYRUNTIME_12HOURS = 12,
  BATTERYRUNTIME_13HOURS = 13,
  BATTERYRUNTIME_14HOURS = 14,
  BATTERYRUNTIME_15HOURS = 15,
  BATTERYRUNTIME_16HOURS = 16,
  BATTERYRUNTIME_17HOURS = 17,
  BATTERYRUNTIME_18HOURS = 18,
  BATTERYRUNTIME_19HOURS = 19,
  BATTERYRUNTIME_20HOURS = 20,
  BATTERYRUNTIME_21HOURS = 21,
  BATTERYRUNTIME_22HOURS = 22,
  BATTERYRUNTIME_23HOURS = 23,
  BATTERYRUNTIME_24HOURS = 24,
} battery_runtime_t;

typedef enum
{
	RUNTIME_STATE_NOT_INITIALIZED,
	RUNTIME_STATE_POWER_CONSUMPTION_NULL,
	RUNTIME_STATE_POWER_CONSUMPTION_DIE_TOO_LARGE,
	RUNTIME_STATE_INITIALIZED,
}runtime_state_t;

typedef struct
{
	uint8_t ledCount;
	uint8_t dieCount;
	uint16_t powerConsumptionDie[MAX_DIECOUNT];
	uint16_t batteryEnergy;
	uint16_t maximumPower;
	uint16_t availablePower;
	uint16_t averagePower;
	uint16_t averagePowerPrecisionLoss;
	uint16_t timeConstant;
	runtime_state_t state;

}runtime_instance_t;

bool InitRuntime(runtime_instance_t* instance, uint8_t ledCount, uint8_t dieCount,uint16_t* powerConsumptionDie, uint16_t batteryEnergyPerHour, uint16_t timeConstant);
void SetRuntime(runtime_instance_t* instance, battery_runtime_t runtime, uint16_t maximumAllowedPower);
void DoRuntimeSelectionCalculation8Bit(runtime_instance_t* instance, uint8_t* pwm);
void DoRuntimeSelectionCalculation16Bit(runtime_instance_t* instance, uint16_t* pwm);

#endif
