#ifndef RDMLIB_H__
#define RDMLIB_H__

#include <stdbool.h>
#include <stdint.h>
#include "rdmpid.h"

#define SCRDM 0xCC
#define SCSUBMESSAGE 0x1
#define RDMHEADERLENGTH 24

typedef enum
  {
    RDM_DISCOVERY_COMMAND = 0x10,
    RDM_DISCOVERY_COMMAND_RESPONSE = 0x11,
    RDM_GET_COMMAND = 0x20,
    RDM_GET_COMMAND_RESPONSE = 0x21,
    RDM_SET_COMMAND = 0x30,
    RDM_SET_COMMAND_RESPONSE = 0x31 
  } rdm_command_class_t;

  typedef enum
  {
    RDM_ACK, 
    RDM_ACK_TIMER, 
    RDM_NACK_REASON, 
    RDM_ACK_OVERFLOW, 
    RDM_UNKNOWN,
    NUM_RESPONSES
  }rdm_response_t;

  typedef enum
  {
    NR_UNKNOWN_PID,
    NR_FORMAT_ERROR,
    NR_HARDWARE_FAULT,
    NR_PROXY_REJECT,
    NR_WRITE_PROTECT,
    NR_UNSUPPORTED_COMMAND_CLASS,
    NR_DATA_OUT_OF_RANGE,
    NR_BUFFER_FULL,
    NR_PACKET_SIZE_UNSUPPORTED,
    NR_SUB_DEVICE_OUT_OF_RANGE,
    NR_PROXY_BUFFER_FULL
  }rdm_nack_reasoncodes_t;
       
  typedef enum
  {
      CUSTOM = 0,
      DISC_UNIQUE_BRANCH = 0x1,
      DISC_MUTE = 0x2,
      DISC_UN_MUTE = 0x3,
  } rdm_disc_pid_t;

  typedef struct
  {
    bool response;
    rdm_response_t rt;
    rdm_command_class_t cc;
    uint16_t pid_num;
    uint8_t pdl;
    uint8_t tn;
    uint8_t targetRdmId[6];
    uint8_t sourceRdmId[6];
    uint8_t portId;
    uint8_t msgCount;
    bool isBroadcast;
    bool isManufacturerBroadcast;
  } rdm_message_header_t;

 #define RDMDATAPOSITION 24

 uint16_t GetRdmMessageLength(uint8_t dataLength);
 void EncodeRdmMessage(rdm_message_header_t msg,uint8_t* data, uint8_t* buf);
 bool DecodeRdmMessage(uint8_t* msg, uint16_t length, rdm_message_header_t* buf);
 void DecodeRdmId(uint8_t* msg,uint16_t length, rdm_message_header_t* buf);
 rdm_command_class_t DecodeCommandClass(uint8_t* msg,uint16_t length);
 uint16_t DecodePid(uint8_t* msg,uint16_t length);
 #endif
