/**
  ******************************************************************************
  * @file           : managedflash.h
  * @brief          : Simple example for showing managed flash functionality
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_MANAGEDFLASH_H_
#define INC_MANAGEDFLASH_H_

#include <stdbool.h>
#include <stdint.h>

typedef struct
{
  uint8_t  startPage;
  uint8_t  pageLength;
  uint32_t key;
  uint32_t completeLengthAligned;
  uint16_t length;
  uint32_t freePlaces;
  uint32_t actualPlace;

} flash_object_t;

/*==============================================================================*/
/* Function Definitions                                                         */
/*==============================================================================*/

void InitFlash(void);
int8_t FlashRegisterObject(uint16_t objectKey, uint16_t objectLength, uint32_t writeDivider);
bool FlashReadObject(uint8_t objectId, uint8_t* data, uint16_t objectLength, bool* written);
bool FlashGetObjectPointer(uint8_t objectId, uint8_t** data, bool* written);
bool FlashObjectDiff(uint8_t objectId, uint8_t* data, uint16_t bufferLength, bool *changed);
bool FlashWriteObject(uint8_t objectId, uint8_t* data, uint16_t bufferLength);
bool FlashReadObjectHistory(uint8_t objectId, uint8_t* data, uint16_t objectLength, uint32_t historyIndex);
int32_t FlashGetHistoryCount(uint8_t objectId);

/*==============================================================================*/
/* External defined hardware functions                                        	*/
/*==============================================================================*/

extern bool HardwareEraseFlash(uint32_t flashPageAddress, uint32_t flashStartPage, uint32_t flashPages);
extern bool HardwareWriteFlash(uint32_t placeAddress, uint16_t lengthAligned, void* writeBuffer);

#endif /* INC_MANAGEDFLASH_H_ */
