/**
  ******************************************************************************
  * @file           : defines.h
  * @brief          : Global definitions
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

/*==============================================================================*/
/* Includes                                                                  	*/
/*==============================================================================*/
#include "defines.h"

/*==============================================================================*/
/* Defines & Macros                                                           	*/
/*==============================================================================*/
const uint8_t RDM_FOOTPRINTS[RDM_PERSONALITY_COUNT] = {14, 16, 8, RDM_HIGHEST_FOOTPRINT, 14,9,6};
const char RDM_PERSONALITY_NAMES[RDM_PERSONALITY_COUNT][RDMDLABELLENGTH] = {"RGB", "RGBAL", "White", "Layered RGB", "HSV", "Cie xyY", "Lee Filter"};
const char RDM_DEFAULT_DEVICE_LABEL[RDMDLABELLENGTH] = {"Standalone Led Driver"};
const rdm_slot_info_get_response_array_t RDM_SLOT_INFO[RDM_PERSONALITY_COUNT][RDM_HIGHEST_FOOTPRINT] = {
	// Personality 1
	{
			{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
			{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
			{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
			{3,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_RED},
			{4,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_RED},
			{5,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_GREEN},
			{6,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_GREEN},
			{7,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_BLUE},
			{8,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_BLUE},
			{9,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
			{10,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
			{11,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
			{12,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
			{13,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
	},
	// Personality 2
		{
			{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
			{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
			{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
			{3,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_RED},
			{4,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_RED},
			{5,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_GREEN},
			{6,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_GREEN},
			{7,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_BLUE},
			{8,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_BLUE},
			{9,RDM_ST_PRIMARY,RDM_SD_UNDEFINED}, // Amber
			{10,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},// Amber
			{11,RDM_ST_PRIMARY,RDM_SD_UNDEFINED}, // Lime
			{12,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED}, // Lime
			{13,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
			{14,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
			{15,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
		},
	// Personality 3
		{
			{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
			{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
			{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
			{3,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
			{4,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
			{5,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
			{6,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
			{7,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
		},
		// Personality 4
		{
			{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
			{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
			{2,RDM_ST_PRIMARY,RDM_SD_STROBE},

			{3,RDM_ST_PRIMARY,RDM_SD_INTENSITY},
			{4,RDM_ST_SEC_FINE,RDM_SD_INTENSITY},
			{5,RDM_ST_PRIMARY,RDM_SD_STROBE},
			{6,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_RED},
			{7,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_RED},
			{8,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_GREEN},
			{9,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_GREEN},
			{10,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_BLUE},
			{11,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_BLUE},
			{12,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
			{13,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
			{14,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
			{15,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
			{16,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},

			{17,RDM_ST_PRIMARY,RDM_SD_INTENSITY},
			{18,RDM_ST_SEC_FINE,RDM_SD_INTENSITY},
			{19,RDM_ST_PRIMARY,RDM_SD_STROBE},
			{20,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_RED},
			{21,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_RED},
			{22,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_GREEN},
			{23,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_GREEN},
			{24,RDM_ST_PRIMARY,RDM_SD_COLOR_ADD_BLUE},
			{25,RDM_ST_SEC_FINE,RDM_SD_COLOR_ADD_BLUE},
			{26,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
			{27,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
			{28,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
			{29,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
			{30,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
		},
		// Personality 5
		{
				{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
				{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
				{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
				{3,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{4,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{5,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{6,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{7,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{8,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{9,RDM_ST_PRIMARY,RDM_SD_COLOR_CORRECTION},
				{10,RDM_ST_SEC_FINE,RDM_SD_COLOR_CORRECTION},
				{11,RDM_ST_PRIMARY,RDM_SD_COLOR_SCROLL},
				{12,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{13,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
		},
		// Personality 6
		{
				{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
				{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
				{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
				{3,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{4,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{5,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{6,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{7,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{8,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
		},
		// Personality 7
		{
				{0,RDM_ST_PRIMARY,RDM_SD_INTENSITY_MASTER},
				{1,RDM_ST_SEC_FINE,RDM_SD_INTENSITY_MASTER},
				{2,RDM_ST_PRIMARY,RDM_SD_STROBE},
				{3,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
				{4,RDM_ST_SEC_FINE,RDM_SD_UNDEFINED},
				{5,RDM_ST_PRIMARY,RDM_SD_UNDEFINED},
		},
};

const char RDM_PERSONALITY_CHANNEL_NAMES[RDM_PERSONALITY_COUNT][RDM_HIGHEST_FOOTPRINT][RDMDLABELLENGTH] =
{
		// Personality 1
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"Red Coarse"},
				{"Red Fine"},
				{"Green Coarse"},
				{"Green Fine"},
				{"Blue Coarse"},
				{"Blue Fine"},
				{"White Temperature Coarse"},
				{"White Temperature Fine"},
				{"Magenta Green Shift"},
				{"Color Quality Coarse"},
				{"Color Quality Fine"},
		},
		// Personality 2
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"Red Coarse"},
				{"Red Fine"},
				{"Green Coarse"},
				{"Green Fine"},
				{"Blue Coarse"},
				{"Blue Fine"},
				{"Amber Coarse"},
				{"Amber Fine"},
				{"Lime Coarse"},
				{"Lime Fine"},
				{"White Temperature Coarse"},
				{"White Temperature Fine"},
				{"Magenta Green Shift"},
		},
		// Personality 3
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"White Temperature Coarse"},
				{"White Temperature Fine"},
				{"Magenta Green Shift"},
				{"Color Quality Coarse"},
				{"Color Quality Fine"},
		},
		// Personality 4
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Master Strobe"},
				{"Background Dimmer Coarse"},
				{"Background Dimmer Fine"},
				{"Background Strobe"},
				{"Background Red Coarse"},
				{"Background Red Fine"},
				{"Background Green Coarse"},
				{"Background Green Fine"},
				{"Background Blue Coarse"},
				{"Background Blue Fine"},
				{"Background White Temp Coarse"},
				{"Background White Temp Fine"},
				{"Background Magenta Green Shift"},
				{"Background Color Quality Coarse"},
				{"Background Color Quality Fine"},

				{"Foreground Dimmer Coarse"},
				{"Foreground Dimmer Fine"},
				{"Foreground Strobe"},
				{"Foreground Red Coarse"},
				{"Foreground Red Fine"},
				{"Foreground Green Coarse"},
				{"Foreground Green Fine"},
				{"Foreground Blue Coarse"},
				{"Foreground Blue Fine"},
				{"Foreground White Temp Coarse"},
				{"Foreground White Temp Fine"},
				{"Foreground Magenta Green Shift"},
				{"Foreground Color Quality Coarse"},
				{"Foreground Color Quality Fine"},
		},
		// Personality 5
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"Hue Coarse"},
				{"Hue Fine"},
				{"Saturation Coarse"},
				{"Saturation Fine"},
				{"Intensity Coarse"},
				{"Intensity Fine"},
				{"White Temperature Coarse"},
				{"White Temperature Fine"},
				{"Magenta Green Shift"},
				{"Color Quality Coarse"},
				{"Color Quality Fine"},
		},
		// Personality 5
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"Cie x Coarse"},
				{"Cie x Fine"},
				{"Cie y Coarse"},
				{"Cie y Fine"},
				{"Color Quality Coarse"},
				{"Color Quality Fine"},
		},

		// Personality 6
		{
				{"Master Dimmer Coarse"},
				{"Master Dimmer Fine"},
				{"Strobe"},
				{"Filter value"},
				{"Color Quality Coarse"},
				{"Color Quality Fine"},
		},
};
