/**
  ******************************************************************************
  * @file           : variables.c
  * @brief          : Simple example for showing dmx functionality
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/


#ifndef INC_VARIABLES_H_
#define INC_VARIABLES_H_

#include "defines.h"
#include "stdbool.h"
#include "rdmpid.h"

typedef void (*notify_callback_t)(void);

void InitVariables(void);
void VariablesTask(void);

//Serial Number
const uint64_t* get_serial(void);
void set_serial(uint64_t serial);
void deregister_notify_serial(notify_callback_t callback);
void register_notify_serial(notify_callback_t callback);

//Rdm Id
rdmid_t get_rdmid(void);

//Device Label
const device_label_t* get_deviceLabel(void);
void set_deviceLabel(device_label_t label);

//Device Hours
const uint32_t* get_deviceMinutes(void);
void set_deviceMinutes(uint32_t hours);

//Lamp / Source Hours
const uint32_t* get_sourceMinutes(void);
void set_sourceMinutes(uint32_t hours);

//Power Cycles
const uint32_t* get_powerCycles(void);
void set_powerCycles(uint32_t cycles);

//DMX Personality/Mode
const uint8_t* get_dmxPersonality(void);
bool set_dmxPersonality(uint8_t mode);

//DMX StartAdress
const uint16_t* get_dmxStartadress(void);
void set_dmxStartadress(uint16_t adress);

//Factory Defaults
bool get_factoryDefault(void);
void set_factoryDefault(void);

// Rdm Identify
const bool* get_rdmIdentify(void);
void set_rdmIdentify(bool enabled);
void deregister_notify_rdmIdentify(notify_callback_t callback);
void register_notify_rdmIdentify(notify_callback_t callback);

//Dimmer Curve
const float* get_ntcBeta(void);
void set_get_ntcBeta(float beta);

// Driver Dimmer
const uint16_t* get_driverDimmer(void);
void set_driverDimmer(uint16_t dimmer);
void deregister_notify_driverDimmer(notify_callback_t callback);
void register_notify_driverDimmer(notify_callback_t callback);

// PCB ID
void set_pcbId(uint16_t pcbId);
const uint16_t* get_pcbId(void);

// Variable
const uint8_t* get_pcbVersion(void);
void set_pcbVersion(uint8_t dimmer);

const cc_key_store_t* get_ccKey(void);
void set_ccKey(cc_key_store_t data);

const cc_calibration_store_t* get_ccCal(void);
void set_ccCal(cc_calibration_store_t data);

#endif /* INC_VARIABLES_H_ */

