/**
  ******************************************************************************
  * @file           : system_implementation.h
  * @brief          : Simple example for showing rdm functionality using the provided rdm library
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_SYSTEM_IMPLEMENTATION_H_
#define INC_SYSTEM_IMPLEMENTATION_H_

#include "main.h"

typedef struct
{
	UART_HandleTypeDef* dmxHuart;
	GPIO_TypeDef* dmxDirPort;
	uint16_t dmxDdirPin;
	UART_HandleTypeDef* linkHuart;
	volatile uint32_t *dimmer1PwmRegister;
	volatile uint32_t *dimmer2PwmRegister;
	volatile uint32_t *dimmer3PwmRegister;
	volatile uint32_t *dimmer4PwmRegister;
	volatile uint32_t *dimmer5PwmRegister;
	GPIO_TypeDef* ledSignalPort;
	uint16_t ledSignalPin;
} system_hal_config_t;

void SystemTask(void);
void InitSystem(system_hal_config_t config);
void SystemDimmerPeriodElapsedCallback(uint8_t dimmerIndex);

#endif /* INC_SYSTEM_IMPLEMENTATION_H_ */
