/**
  ******************************************************************************
  * @file           : led_driver.h
  * @brief          : Led driver which control powerstage, current and dimming
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_RUNTIMEIMP_H_
#define INC_RUNTIMEIMP_H_

#include "stdbool.h"
#include "stdio.h"
#include <stdint.h>
#include "main.h"
#include "libRuntime.h"

void RuntimeImpDimmerPeriodElapsedCallback(uint8_t dimmerIndex);
void RuntimeImpSetDMXPersonaliy1(const uint8_t* data);
void RuntimeImpSetBatteryRuntime(uint8_t runtimeHours);
void RuntimeImpTask(uint32_t tickMs);
void InitRuntimeImp(volatile uint32_t *dimmer1Register, volatile uint32_t *dimmer2Register, volatile uint32_t *dimmer3Register, volatile uint32_t *dimmer4Register, volatile uint32_t *dimmer5Register);
bool RuntimeImpLightisOn(void);

#endif /* INC_RUNTIMEIMP_H_ */
