/**
  ******************************************************************************
  * @file           : adc.h
  * @brief          : Simple example for measuring voltage using adc
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_MEASUREMENT_H_
#define INC_MEASUREMENT_H_

#include "stdbool.h"
#include "stdio.h"
#include <stdint.h>

void InitMeasurement(void);
float Measurement_GetOutputPower(void);
float Measurement_GetOutputCurrentRipple(void);
float Measurement_GetOutputCurrentSwitchingFrequencyKHz(void);
float Measurement_GetOutputCurrent(void);
float Measurement_GetOutputVoltage(void);
float Measurement_GetPcbTemperature(void);
float Measurement_GetTemperatureNtc(void);
float Measurement_GetInputVoltage(void);
float Measurement_GetIcTemperature(void);
void Measurement_JunctionTransient(void);
void Measurement_JunctionStatic(void);
#endif /* INC_OUTPUT_H_ */
