/**
  ******************************************************************************
  * @file           : dmx_512.h
  * @brief          : Handle DMX and RDM phyiscal interface
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

#ifndef INC_DMX_512_H_
#define INC_DMX_512_H_

#include "stdbool.h"
#include "stdio.h"
#include <stdint.h>
#include "main.h"

void InitDMX512(UART_HandleTypeDef* _huartDmx,GPIO_TypeDef* _dirPort, uint16_t _dirPin, void (*dmxCallback)(const uint8_t * msg, uint16_t length), void (*rdmCallback)(const uint8_t * msg, uint16_t length));
void DMX512_Task(void);
void DMX512_WriteRdmFrame(const uint8_t* data, uint16_t length);
void DMX512_WriteData(const uint8_t* data, uint16_t length);
void DMX512_TxCpltCallback(UART_HandleTypeDef *huart);
void DMX512_ErrorCallback(UART_HandleTypeDef *huart);
#endif /* INC_DMX_512_H_ */
