/**
  ******************************************************************************
  * @file           : defines.h
  * @brief          : Global definitions
  ******************************************************************************
  * @attention
  *
  * Copyright (c) Kuenzler Technologies GbR
  * All rights reserved.
  *
  *
  ******************************************************************************
*/

/*==============================================================================*/
/* Includes                                                                  	*/
/*==============================================================================*/

#ifndef INC_DEFINES_H_
#define INC_DEFINES_H_

#include "rdmpid.h"

#define VERSIONMAJOR  	0
#define VERSIONMINOR  	0
#define VERSIONPATCH  	0
#define VERSIONRELEASE  1

// RDM User
#define RDM_MANUFACTURER 				0x676C // Example Manufacturer
#define RDM_DEVICEMODEL_ID 				2
#define RDM_PRODUCT_CATEGORY 			1
#define RDM_DEVICE_MODEL_DESCRIPTION 	"Example Light-Control"
#define RDM_MANUFACTURER_NAME 			"KKT"
#define RDM_PRODUCT_DETAIL 				0x0404//PRODUCT_DETAIL_LED;
#define RDM_PERSONALITY_COUNT 			7
#define RDM_SENSOR_COUNT 				2

#define RDM_HIGHEST_FOOTPRINT 31

extern const uint8_t RDM_FOOTPRINTS[];
extern const char RDM_PERSONALITY_NAMES[][RDMDLABELLENGTH];
extern const char RDM_DEFAULT_DEVICE_LABEL[];

extern const rdm_slot_info_get_response_array_t RDM_SLOT_INFO[][RDM_HIGHEST_FOOTPRINT];
extern const char RDM_PERSONALITY_CHANNEL_NAMES[][RDM_HIGHEST_FOOTPRINT][RDMDLABELLENGTH];
// DMX User
#define DMX_DEFAULT_STARTADDRESS 1
#define DMX_DEFAULT_PERSONALITY 1
#define DMX_DEFAULT_DIMMER_CURVE 1
#define DMX_DEFAULT_INPUT_SOURCE 0

#define DIE_COUNT 5
#define LED_COUNT 1

#define MINUTES_MS	60000

#define BATTERY_DECI_WH 100


typedef struct
{
	char array[RDMDLABELLENGTH];
} device_label_t;

typedef struct
{
	uint8_t array[6];
} rdmid_t;

typedef struct
{
	uint8_t array[32];
}cc_key_store_t;

typedef struct
{
	uint16_t array[LED_COUNT][DIE_COUNT];
}cc_calibration_store_t;


#endif /* INC_DEFINES_H_ */
